%---------------------------------------------------------------------  
% function [block_index, line_start, line_stop, line_numbers] = FT_find_text_in_all_blocks(blocks,searchtext)
% 
% Finds a search string in a block and returns the line numbers
% where it was found.
%
% blocks: vector of block structure
% searchtext: string, text to search for
% block_index: vector of integers, givin the blocks in which the text 
%              was found
% line_stop, vector of integers pointing into line_numbers, see below
% line_start, vector of integers pointing into line_numbers, see below
% line_numbers, vector of integers, giving the lines in which 
%               searchtext was found
%
% So, if lines 2 and 5 of block 3 contained the text the solution will include
% block_index(i)=3
% line_numbers(line_start(i):line_stop(i))= [2 5]
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [block_index, line_start, line_stop, line_numbers] = FT_find_text_in_all_blocks(blocks,searchtext)

  baseid='FT_find_text_in_all_block';
    
  if (~isstruct(blocks))
    msgid=[baseid,':checkinarg'];
    result='first input argument must be a block structure';
    error(msgid,result);
  end
  
  if (~isstr(searchtext))
    msgid=[baseid,':checkinarg'];
    result='second input argument must be a string';
    error(msgid,result);
  end
  
  block_index=[];
  line_numbers=[];
  line_start=[];
  line_stop=[];

  n_blocks=length(blocks);
  index=1;
  startat=1;
  
  for i=1:n_blocks
    new_lines=FT_find_text_in_active_block(blocks(i),searchtext);
    n_lines=length(new_lines);
    if (n_lines)
      block_index=[block_index,i];
      line_start(index)=startat;
      line_stop(index)=startat+n_lines-1;
      line_numbers=[line_numbers,new_lines];
      startat=startat+n_lines;
      index=index+1;
    end
  end
  

  
    
  