%---------------------------------------------------------------------  
% function [line_numbers] = FT_find_text_in_active_block(block,searchtext)
% 
% Finds a search string in a block and returns the line numbers
% where it was found. This function differs from FT_find_text_in_block
% in that it excludes all comment lines in the search
%
% block: block structure
% searchtext: string, text to search for
% line_numbers, vector of integers, giving the lines in which 
%               searchtext was found
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [line_numbers] = FT_find_text_in_active_block(block,searchtext)

  baseid='FT_find_text_in_block';
    
  if (~isstruct(block))
    msgid=[baseid,':checkinarg'];
    result='first input argument must be a block structure';
    error(msgid,result);
  end
  
  if (~isstr(searchtext))
    msgid=[baseid,':checkinarg'];
    result='second input argument must be a string';
    error(msgid,result);
  end
  
  line_numbers=[];
  for i=1:block.n_lines
    line_text=FT_remove_comment_line(block.txt_lines(i));
    found=strfind(line_text,searchtext);
    if (found)
      line_numbers = [line_numbers, i];
    end
  end
  
    
  