%---------------------------------------------------------------------  
% function [block_index, line_start, line_stop, line_numbers] = FT_find_element_in_block(blocks, position, value)
% 
% Returnes block_index and line numbers for which the element 
% specified by position and value has been found.
%
% blocks: vector of block structures
% position: integer, specifying the element's position
% value: double or string which is the element's content
%
% block_index: vector of integers, givin the blocks in which the element
%              was found
% line_stop, vector of integers pointing into line_numbers, see below
% line_start, vector of integers pointing into line_numbers, see below
% line_numbers, vector of integers, giving the lines in which 
%               element was found
%
% So, if lines 2 and 5 of block 3 contained the element the solution will include
% block_index(i)=3
% line_numbers(line_start(i):line_stop(i))= [2 5]
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [block_index, line_start, line_stop, line_numbers] = FT_find_element_in_block(blocks, position, value)

  % base string for error message id
  baseid='FT_find_element_in_block';

  if (~isstruct(blocks))
    msgid=[baseid,':checkinarg'];
    result='first input argument must be a block structure';
    error(msgid,result);
  end

  block_index=[];
  line_numbers=[];
  line_start=[];
  line_stop=[];

  n_blocks=length(blocks);
  index=1;
  startat=1;
  
  for i=1:n_blocks
    new_lines=FT_find_element_in_active_block(blocks(i),position, value);
    n_lines=length(new_lines);
    if (n_lines)
      block_index=[block_index,i];
      line_start(index)=startat;
      line_stop(index)=startat+n_lines-1;
      line_numbers=[line_numbers,new_lines];
      startat=startat+n_lines;
      index=index+1;
    end
  end
  
