%---------------------------------------------------------------------  
% function [lines] = FT_find_element_in_active_block(block, position, value)
% 
% Returnes line numbers for which the element specified by position and value
% has been found. This differs from FT_find_element_in_block in that
% is excludes all commented lines.
% block: single block structure
% position: integer, specifying the element's position
% value: double or string which is the element's content
% lines: vector of integers containing line numbers where elements where found
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [lines] = FT_find_element_in_active_block(block, position, value)

  % base string for error message id
  baseid='FT_find_element_in_block';

  if (~isstruct(block))
    msgid=[baseid,':checkinarg'];
    result='first input argument must be a block structure';
    error(msgid,result);
  end

  pos=int8(position);
  if(pos~=position)
    msgid=[baseid,':checkinarg'];
    msg='second input argument must be of type integer';
    error(msgid,msg);    
  end

  if (iscell(value))
    value=cell2mat(value);
  end

  if (isstr(value))
    str2=value;
  else
    str2=num2str(value);
  end

  lines=[];
  for i=1:block.n_lines
    text_line=FT_remove_comment_line(block.txt_lines(i));
    if (text_line)
      [element,estart,eend]=FT_get_element_from_line(text_line,pos);
      if (strcmp(element,str2))
        lines=[lines,i];
      end
    end
  end
  
