%---------------------------------------------------------------------  
% function [block] = FT_create_new_block(name)
% 
% Creates a new 'block' structure.
%
% name: string, name of block
% block: empty block structure
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [block] = FT_create_new_block(name)
  
  baseid='FT_create_new_block';
  
  if (~isstr(name))
    msgid=[baseid,':checkinarg'];
    result='input argument must be a string';
    error(msgid,result);
  end
  
  block=struct('name',strtrim(name),'filename','','edited',0,'n_lines',0,'txt_lines','');
  