%---------------------------------------------------------------------  
% function [block] = FT_copy_lines_block_to_block(inblock,block,lines)
% 
% Copy a set of lines from one block to another
%
% inblock: block structure from which the lines are copied
% lines: vector of integers, giving the line numbers
%
% block: block structure to which the lines should be added
%
% Part of the SimTools package
% Andreas Freise 16.06.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [block] = FT_copy_lines_block_to_block(inblock,block,lines)

  baseid='FT_copy_lines_block_to_block';
    
  if (~isstruct(inblock))
    msgid=[baseid,':checkinarg'];
    result='first input argument must be a block structure';
    error(msgid,result);
  end

  if (~isstruct(block))
    msgid=[baseid,':checkinarg'];
    result='second input argument must be a block structure';
    error(msgid,result);
  end
 
  if (~isnumeric(lines))
    msgid=[baseid,':checkinarg'];
    result='third input argument must be numeric';
    error(msgid,result);
  end

  if (lines>inblock.n_lines)
    msgid=[baseid,':checkinarg'];
    result='line numbers given larger than block length';
    error(msgid,result);    
  end 

  bl=length(inblock);
  if (bl>1)
    msgid=[baseid,':checksize'];
    error(msgid,'first argument must be single FTblock');
  end

  bl=length(block);
  if (bl>1)
    msgid=[baseid,':checksize'];
    error(msgid,'second argument must be single FTblock');
  end
  
  for i=lines
    block=FT_add_line_to_block(block,inblock.txt_lines(i));
    block.n_lines=block.n_lines+1;
    block.edited=1;
  end
  
