%---------------------------------------------------------------------  
% function [outblock] = FT_copy_block(blocks, name)
% 
% return one block from a list of blocks, given by name
% 
% blocks: vector of blocks
% name: name or index of block to be returned
% outblock: single block
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

 function [outblock] = FT_copy_block(blocks, name)

  % base string for error message id
  baseid='FT_copy_block';

  if (isstr(name))
    index=FT_index_of_block(blocks,name);
  else 
    if (isnumeric(name))
      index=name;
    else
      msgid=[baseid,':checkinarg'];
      result='could not find block name or index';
      error(msgid,result);
    end
  end

  outblock=blocks(index);
  

  
      
  