%---------------------------------------------------------------------  
% function [block] = FT_comment_lines_in_block(block,line_numbers)
% 
% Add comment char in front of lines given by line number.
%
% block: block structure
% line_numbers: vector of integers, specifying lines to be commented
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [block] = FT_comment_lines_in_block(block,line_numbers)

  baseid='FT_comment_lines_in_block';
    
  if (~isstruct(block))
    msgid=[baseid,':checkinarg'];
    result='first input argument must be a block structure';
    error(msgid,result);
  end
  
  if (~isnumeric(line_numbers))
    msgid=[baseid,':checkinarg'];
    result='second input argument must be numeric';
    error(msgid,result);
  end
  
  if (line_numbers>block.n_lines)
    msgid=[baseid,':checkinarg'];
    result='line numbers given larger than block length';
    error(msgid,result);    
  end

  for i=line_numbers
    block.txt_lines(i)={FT_add_comment_char_to_line(cell2mat(block.txt_lines(i)))};
  end
  block.edited = 1;
    
  