%---------------------------------------------------------------------  
% function [block] = FT_add_line_to_block(block,txt_line)
% 
% Add a line of text to a given block.
%
% block: block structure to which the text should be added
% txt_line: string, one line of text, which should be added
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [block] = FT_add_line_to_block(block,txt_line)

  baseid='FT_add_line_to_block';
    
  if (iscell(txt_line))
    txt_line=cell2mat(txt_line);
  end
    
  if (~isstruct(block))
    msgid=[baseid,':checkinarg'];
    result='first input argument must be a block structure';
    error(msgid,result);
  end
  
  if (~isstr(txt_line))
    msgid=[baseid,':checkinarg'];
    result='second input argument must be a string';
    error(msgid,result);
  end
  
  bl=length(block);
  if (bl>1)
    msgid=[baseid,':checksize'];
    error(msgid,'first argument must be single FTblock');
  end
  
  block.txt_lines=[block.txt_lines,{txt_line}];
  block.n_lines=block.n_lines+1;
  block.edited=1;
  end
  
