%
%--------------------------------------------------------------------------
% FTE_finesse_04.m
%
% Test example that describes the basics of using SimTools with
% Finesse. This script reads an existing Finesse input file, 
% and demonstrates how to change the value of a constant.
%
% This file requires file `testconsts.kat'. 
%
% Part of the SimTools package
% Andreas Freise  12.02.2011
%--------------------------------------------------------------------------
%

% Description: Example for using SimTools with Finesse: changing value of a constant.
% Keywords: finesse, example, simulation, kat

clear all;

% name of kat file which contains 'blocks'
inname='testconsts.kat';

% read in block from testblock.kat
block=FT_read_blocks_from_file(inname);
myblock=FT_copy_block(block,'constants');

disp('----------------------------------------------------------');
% print reflectivies 
r1=FT_read_kat_constant(myblock,'Rm1');
r2=FT_read_kat_constant(myblock,'Rm2');
disp(sprintf('Reflectivities of m1 and m2: %f %f',r1,r2));

% now we change the reflectivity for one of m
myblock=FT_write_kat_constant(myblock,'Rm1',0.7);

%to check we print the block again
disp('----------------------------------------------------------');
disp('block of constants after changing Rm1:');
FT_print_block(myblock,'constants');

disp('----------------------------------------------------------');
disp('creating a tmp block from lines 1-4 of the constants');
newblock=FT_create_new_block('tmp');
[newblock]=FT_copy_lines_block_to_block(myblock,newblock,1:4);
FT_print_block(newblock,'tmp');


