%
%--------------------------------------------------------------------------
% FTE_finesse_03.m
%
% Test example that describes the basics of using SimTools with
% Finesse. This script reads an existing Finesse input file, 
% and demonstrates how to find, print and change information
% related to specific parameters. See also example 04 for an
% easier way to do this with constants.
%
% This file requires file `testblock.kat'. 
%
% Part of the SimTools package
% Andreas Freise  12.02.2011
%--------------------------------------------------------------------------
%

% Description: Example for using SimTools with Finesse: finding specific parameters.
% Keywords: finesse, example, simulation, kat

clear all;

% name of kat file which contains 'blocks'
inname='testblock.kat';

% read in block from testblock.kat
block=FT_read_blocks_from_file(inname);

myblock=FT_copy_block(block,'cavity');

%FT_print_block(myblock,'cavity');

disp('----------------------------------------------------------');
disp('Printing reflectivities of all mirrors:');

% Printing all reflectivities of the mirrors:
for i=1:myblock.n_lines
  mir=FT_parse_line(myblock.txt_lines(i),[1,2,3]);
  command=cell2mat(mir{1});
  name=cell2mat(mir{2});
  if (command(1)=='m')
    disp(sprintf('mirror %s reflectance: %g',name,mir{3}));
  end
end
 
% now we change the one of m2
[mir_lines]=FT_find_element_in_active_block(myblock,1,'m');

for i=mir_lines
  [mir_name,p1,p2]=FT_get_element_from_line(myblock.txt_lines(i),2);
  if (mir_name=='m2')
    myblock.txt_lines(i)={FT_replace_value_in_line(myblock.txt_lines(i),3,0.7)};
  end
end

disp('----------------------------------------------------------');
disp('Printing block after m2 R has been changed');

FT_print_block(myblock,'cavity');

disp('----------------------------------------------------------');
disp('Finding all blocks containg mirrors');
[b_index,l1,l2,lines]=FT_find_element_in_all_blocks(block,1,'m');
for i=1:length(b_index)
  disp(sprintf('Found %d mirrors in block %s\n',l2(i)-l1(i)+1,block(b_index(i)).name));
end

disp('----------------------------------------------------------');
disp('Finding all blocks containg the text m1');
[b_index,l1,l2,lines]=FT_find_text_in_all_blocks(block,'m1');
for i=1:length(b_index)
  disp(sprintf('in block %s:\n',block(b_index(i)).name));
  for j=l1(i):l2(i)
    disp(sprintf('line %d: %s:\n',lines(j),cell2mat(block(b_index(i)).txt_lines(lines(j)))));
  end
end

