%
%--------------------------------------------------------------------------
% FTE_finesse_02.m
%
% Test example that describes the basics of using SimTools with
% Finesse. This script reads an existing Finesse input file, 
% changes it, writes it back to disk and runs Finesse with the
% new file.
% 
% This file requires file `testblock.kat'. 
% **You need to adapt the line FT=FT_init_Finesse(...); manually**
%
% Part of the SimTools package
% Andreas Freise  12.02.2011
%--------------------------------------------------------------------------
%

% Description: Example for using SimTools with Finesse: read and write a Finesse input file.
% Keywords: finesse, example, simulation, kat

clear all;

% the following lines are the same as in FTE_finesse_01.m
% initialise Finesse, adapt to your system
FT=FT_init_Finesse('name','kat','path','~/work/bin/');
FT=FT_check_for_kat_binary(FT);

% name of kat file which contains 'blocks'
inname='testblock.kat';
% name of file that we will create now from this script
katname='mytest.kat';

% read in block from testblock.kat
block=FT_read_blocks_from_file(inname);

% now selectively copy some blocks from the list 'block' over
% into the list 'outbl'.
% we can access the block usually by name or by index:
outbl(1)=FT_copy_block(block,2); %second block is the 'laser'
outbl(2)=FT_copy_block(block,'cavity');
outbl(3)=FT_copy_block(block,'detection');

for  runno=1:2
  % create a new block by hand, containing just an xaxis command
  outbl(4)=FT_create_new_block('command1');
  xaxis_str=sprintf('xaxis m%d phi lin 0 10 100',runno);
  outbl(4)=FT_add_line_to_block(outbl(4),xaxis_str);

  % write all blocks from list 'outbl' to file 'mytest.kat'
  FT_write_blocks_into_file(outbl,katname);

  % BTW we could delete things from the block
  % e.g. this finds all lines containing an 'm'
  %xxx=FT_find_text_in_block(outbl(2),'m');
  % and now we delete them
  %outbl(2)=FT_remove_lines_from_block(outbl(2),xxx);

  % run Finese and read data
  Run(runno)=FT_create_new_kat_run();
  Run(runno).filename=katname;
  Run(runno)=FT_run_kat_simulation(FT,Run(runno));
end

plot(Run(1).x,Run(1).y,Run(2).x,Run(2).y,'g-.')

% clean directory again
%FT_kat_clean(Run1);