%
%--------------------------------------------------------------------------
% FTE_finesse_01.m
%
% Test example that describes the basics of using SimTools with
% Finesse. This script will simply call Finesse to run a pre-existing
% simulation file and reads the output date. No output will be plotted
% or printed. This script is simply for you to understand how to
% setup SimTools such that is finds the Finesse binary and can
% start Finesse.
% 
% This file requires file `testblock.kat'. 
% **You need to adapt the line FT=FT_init_Finesse(...); manually**
%
% Part of the SimTools package
% Andreas Freise  12.02.2011
%--------------------------------------------------------------------------
%

% Description: Example for using SimTools with Finesse: find the kat binary.
% Keywords: finesse, example, simulation, kat

clear all;

% Create FT variable, which contains the path to 'kat'
% Change the line below to point SimTools to your version of the 
% Finesse binary `kat' or `kat.exe'
FT=FT_init_Finesse('name','kat','path','/Users/adf/bin/');
FT=FT_check_for_kat_binary(FT);

% Create a new 'run' variable, a structure to hold Finess related data
Run1=FT_create_new_kat_run();
% Set the filename to 'testblock', i.e.
Run1.filename='testblock';

% Start Finesse for the given file and read data from testblock.out
Run1=FT_run_kat_simulation(FT,Run1,0);

% clean directory again
FT_kat_clean(Run1);