%---------------------------------------------------------------------  
% function [katfile,outfile,logfile,mfile, gnufile]= FT_set_kat_filenames(basename)
% 
% Returns the common Finesse filenames for a given basename.
%
% basename: string, filename of the Finesse input file without
%           '.kat' extension
% katfile: input filename with extension .kat
% outfile: output data filename with extension .out
% logfile: output log filename with extension .log
% mfile:   output matlab filename with extension .m
% gnufile: output gnuplot filename with extension .gnu
%
% Part of the SimTools package
% Andreas Freise 16.06.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [katfile,outfile,logfile,mfile, gnufile]= FT_set_kat_filenames(basename)

  % base string for error message id
  baseid='FTfilename';
  
  % check for right number of outputs
  msg = nargoutchk(5, 5, nargout);
  if (msg)
    msgid=[baseid,':checkoutputs'];
    error(msgid,msg)
  end

   if (~isstr(basename))
    msgid=[baseid,':checkinarg'];
    result='input argument must be a string';
    error(msgid,result);
  end
   
  katfile=[basename,'.kat'];
  outfile=[basename,'.out'];
  logfile=[basename,'.log'];  
  mfile=  [basename,'.m'];
  gnufile=[basename,'.gnu'];
  
  