%---------------------------------------------------------------------  
% function [basename]= FT_prepare_kat_filename(filename)
% 
% Checks a given string whether it is suitable as a
% Finesse input filename, it removes whitespace. It also 
% removes the extensions .kat or trailing dots and
% returns a 'basename'.
%
% filename: string, filename before checking
% basename: string, returned filename without extension
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function [basename]= FT_prepare_kat_filename(filename)

  % base string for error message id
  baseid='FT_prepare_kat_filename';
  % check for right number of outputs
  msg = nargoutchk(1, 1, nargout);
  if (msg)
    msgid=[baseid,':checkoutputs'];
    error(msgid,msg)
  end

  
  if (~isstr(filename))
    msgid=[baseid,':checkinarg'];
    msg='input argument must be a filename';
    error(msgid,msg);
  end
  
  % remove whitespace characters at begining and end
  filename=strtrim(filename);

  % check for '.kat'
  nl=length(filename);
  if (nl>4)
    tmp=strcmp(filename(nl-3:nl),'.kat');
    if (tmp) % found, now remove it
      filename=filename(1:nl-4);
    end
  end

  % check for trailing '.'
  nl=length(filename);
  if (filename(nl)=='.')
    % found, now remove dot
    nl=nl-1;
  end

  basename=filename(1:nl);

  % check for whitespace characters inside filename
  tmperror=max(isspace(basename));
  if (tmperror)
    msgid=[baseid,':checkname'];
    error(msgid,'"%s" is not a valid filename', filename);
  end
  
  