function [max_x_val,max_y_val,min_x_val,min_y_val] = FT_min_max(Run)
%---------------------------------------------------------------------  
% function [max_x_val,max_y_val,min_x_val,min_y_val] = FT_min_max(Run)
% 
% Stores the min and max values of all detectors used in the Finesse 
% simulation in dedicated vectors and plots additionally a descriptive line
% output into the console
%
% Run: structure defining the input file
%
% max_x_val: vector containing x values corresponding to the maxima of all detectors
% max_y_val: vector containing maxima values of all detectors
% min_x_val: vector containing x values corresponding to the minima of all detectors
% min_y_val: vector containing minima values of all detectors
%
% Part of the SimTools package
% Simon Chelkowski 28.04.09 simon.chelkowski@ligo.org
%---------------------------------------------------------------------  

detector_no = length(Run.col_names)-1;

[max_y_val,max_y_element]=max(Run.y);
[min_y_val,min_y_element]=min(Run.y);
[max_x_val] = Run.x(max_y_element);
[min_x_val] = Run.x(min_y_element);

% Print result if no output arguments are given
%   (Finesse output using '-max' command looks like
%   # Qrapd  max  x 90  : 9.110686381e-009 , min  x -4  : -1.465502789e-007)
if (nargout==0)
  display(' ')
  for i=1:detector_no    
    display(sprintf('%s  max: x=%.15g, y=%.15g;  min: x=%.15g, y=%.15g ',cell2mat(Run.col_names(i+1)),max_x_val(i),max_y_val(i),min_x_val(i),min_y_val(i)));
  end
  display(' ')
  % don't return values
  clear max_x_val max_y_val min_x_val min_y_val
end



