%---------------------------------------------------------------------  
% function []=FT_kat_clean(Run)
% 
% Removes all output file from a simulation run.
%
% Run: structure containing the input file and output data 
%      of a Finesse simulation
%
% Part of the SimTools package
% Andreas Freise 18.06.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function []=FT_kat_clean(Run)
  
  baseid='FT_kat_clean';

    if (~isstruct(Run))
    msgid=[baseid,':checkinarg'];
    msg='input argument must be a "run" structure';
    error(msgid,msg);
  end

   basename=FT_prepare_kat_filename(Run.filename);
  [katfile,outfile,logfile,mfile,gnufile]=FT_set_kat_filenames(basename);

  FT_delete_file(outfile);
  FT_delete_file(logfile);
  FT_delete_file(gnufile);
  FT_delete_file(mfile);
  
  