% Keywords: convert, finesse, 4D

function [x1,x2,x3,M]=FT_convert_finesse4D(X1,X2,X3,Z)
[row,col]=size(Z);
nx3p=row/length(find (X1(:)==X1(1)));
nx1p=length(find (X2(:)==X2(1)))/nx3p;
nx2p=row/nx3p/nx1p;

x3=X1(1:nx1p*nx2p:row);
x1=X2(1:nx2p:nx1p*nx2p);
x2=X3(1:nx2p);

M=zeros(nx1p,nx2p,nx3p,col);
for i=1:col
M(:,:,:,i)=reshape(Z(:,:,i),nx1p,nx2p,nx3p);
end
