%---------------------------------------------------------------------  
% function [FT] = FT_check_for_kat_binary(FT)
% 
% Checks if the Finesse binary can be found and tests which
% kat.ini file can be used
%
% FT: FT structure
%
% Part of the SimTools package
% Andreas Freise 22.05.08 afreise@googlemail.com
%---------------------------------------------------------------------  

function found = FT_check_for_kat_binary(FT)

  baseid='FTchekforkat';
  
  found=0;
  
  if (~isstruct(FT))
    msgid=[baseid,':checkinarg'];
    result='input argument must be a FT structure';
    error(msgid,result);
  end
  
  disp('--------------------------------------------------------------------');
  % check if katbinary exists and produces a version output
  commandstring = [FT.katbinary,' -v'];
  [status,result]=system(commandstring);
  if (~status)
    isFinesse=strfind(result,'Finesse');
    if (isFinesse)
      disp(['Finesse binary found: ',strtrim(result)]);
      found=1;    
    end
  end
   
  
  
