%
%--------------------------------------------------------------------------
% FTE_power_in_field.m
%
% Test example for FT_power_in_field()
%
% Part of the SimTools package
% Andreas Freise  30.11.2009
%--------------------------------------------------------------------------
%

% Description: Example for using computing the total power in a complex field array.
% Keywords: example, field, power, Gauss

clear all;
% parameter initialisation
lambda = 1064e-9;
% beam width in the x and y direction
w0x = 0.01;
% distance to beam waist
zx = 0;

[gp] = FT_init_gauss_param(lambda,1,'w0',w0x,'z',zx);

% Size of grid  defined as +-range
xrange=4e-2;
yrange=4e-2;
% number of points of the grid
xpoints=200;
ypoints=500;
% vector to address all x and y values
x=linspace(-xrange,xrange,xpoints);
y=linspace(-yrange,yrange,ypoints);

disp('----------------------------------------------------------------------------------------');
disp(sprintf('Example 1: linear spaced grid, %dx%d points,\n           range x/(2w0x)=%g, y/(2w0y)=%g\n',...
xpoints,ypoints,xrange/w0x,yrange/w0x));

field=sqrt(0.1)*FT_LG_field(gp,0,2,x,y,[0,0,0])...
    +i*sqrt(0.7)*FT_LG_field(gp,2,0,x,y,[0,0,0])...
     +sqrt(0.2)*FT_HG_field(gp,1,0,x,y,[0,0,0]);
     
power=FT_power_in_field(field,x,y);

disp(sprintf('total power: %.15g W (should be 1)\n',power));

%--------------------------------------------------------------------
xrange=4e-2;
yrange=4e-2;
% number of points of the grid
xpoints=1500;
ypoints=500;
% vector to address all x and y values
x=logspace(-7,log10(xrange),xpoints);
y=linspace(-yrange,yrange,ypoints);

field=FT_LG_field(gp,0,-2,x,y,[0,0,0]);
disp('----------------------------------------------------------------------------------------');
disp(sprintf('Example 2: log/linear spaced grid, %dx%d points,\n           range x/(2w0x)=%g, y/(2w0y)=%g\n',...
xpoints,ypoints,xrange/w0x,yrange/w0x));

power=FT_power_in_field(field,x,y);

disp(sprintf('total power: %.15g W (should be 0.5)\n',power));


