%
%--------------------------------------------------------------------------
% FTE_plot_Gauss.m
%
% Example file that simply plots a Gaussian beam profile
%
% Part of the SimTools package
% Andreas Freise  21.10.2011
%--------------------------------------------------------------------------
%

% Description: Example for plotting a Gaussian beam profile
% Keywords: example, plot, power, Gauss

clear all;

% set wavelength and index of refraction
lambda=1064e-9;
nr=1;

% set waist size and position
w0=3e-3;
z=7;


% Initialise grid for creating the Gaussian beam (and for plotting)
xpoints=200;
ypoints=200;
xsize=8e-3;
ysize=8e-3;
gridx=5e-3;
gridy=5e-3;
[mygrid] = FT_init_grid(xpoints, ypoints, xsize, ysize, 0,0);

% define Gaussian beam parameter
gp=FT_init_gauss_param(lambda, nr, 'w0',w0,'z',z);

% create complex field amplitude for 0 0 mode of the Gaussian beam
field=FT_HG_field(gp ,0 ,0 ,mygrid.xaxis ,mygrid.yaxis, [0,0,0]);

% compute the beam power 
power=abs(field)^2;
threshold=max(max(power))/5;
[idx]=find(power<threshold);
% set values below a certain threshold to NaN so that these values 
% will not be plotted
power(idx)=NaN; 

scale=1e3; % scale the axis up to [mm] and plot
surf(scale*mygrid.xaxis, scale*mygrid.yaxis,power)
shading interp
axis tight
set(gca, 'XTickLabel', []);
set(gca, 'YTickLabel', []);
axis square
axis xy
view([0 90])
