%
%--------------------------------------------------------------------------
% FTE_mode_contributions.m
%
% Test example for FT_mode_content and related functions. Creates a 
% distorted test beam and analyses its mode content
%
%
% Part of the SimTools package
% Simon Chelkowski, Andreas Freise, 13.11.2009 afreise@googlemail.com
%---------------------------------------------------------------------  
%

% Description: Example for fitting modal decomposition of a Gauss beam
% Keywords: example, mode, Gauss, decomposition, coefficient

% ---- define laser mode
lambda = 1064e-9;
% beam width in the x and y direction
w0 = 0.01;
% distance to beam waist
z = 0;
% create Gaussian beam parameter
[gp] = FT_init_gauss_param(lambda,1,'w0',w0,'z',z);

% ---- define numerical Grid
% size of grid, defined as -range/2 ... range/2
xrange=6e-2;
yrange=6e-2;

% number of points in the grid
xpoints=400;
ypoints=400;

% create grid
Grid=FT_init_grid(xpoints, ypoints, xrange, yrange, 0,0);

% ---- generate test input field
test_field = sqrt(0.2)*FT_LG_field(gp,0,-2,Grid.xaxis,Grid.yaxis,[0,0,0])...
    + 1i*sqrt(0.8)*FT_LG_field(gp,2,0,Grid.xaxis,Grid.yaxis,[0,0,0]) ...
    + FT_HG_field(gp,1,0,Grid.xaxis,Grid.yaxis,[0,0,0]);

% ---- do mode decomposition
max_mode_order = 4;
[gc,n_coeff]=FT_init_gauss_coefficients('LG', max_mode_order);
fprintf('Computing mode coefficients ...\n');
[gc] = FT_mode_content(gc, gp, test_field,Grid.xaxis,Grid.yaxis,[0,0,0]);
FT_print_gauss_coefficients(gc,1e-3,0);
fprintf('Total power in modes %.3g (should be 1)!\n',sum(abs(gc.value(:)).^2));
fprintf('Plotting result ...\n');

% recreate field with mode coefficients
[newfield] = FT_gauss_coefficients_to_field(gp, gc, Grid.xaxis, Grid.yaxis,[0,0,0]);

figure
subplot(1,2,1)
surf(abs(test_field),'FaceColor','interp','EdgeColor','none','FaceLighting','phong');
view(2)
axis square
colorbar;
mymap=FT_neg_colormap();
colormap(mymap)

subplot(1,2,2)
surf(abs(newfield),'FaceColor','interp','EdgeColor','none','FaceLighting','phong');
view(2)
axis square
colorbar;
mymap=FT_neg_colormap();
colormap(mymap)
