%--------------------------------------------------------------------------
% FTE_lg2hg_example.m
%
% A Matlab example script which illustrates the use of the function
% FT_lg2hg.m.  This function outputs the coefficients required to describe 
% a Laguerre-Gauss (LG) mode as a sum of Hermite-Gauss (HG) modes.  Here we
% compare the LG field from the original equation and as a sum of HG modes.
%
% Charlotte Bond    19.11.12
%--------------------------------------------------------------------------
%

clear all;

% Bema indices/ parameters
w0 = 6.2e-2;
p = 2;
l = -5;
lambda = 1064e-9;
gp = FT_init_gauss_param(lambda,1,'z',0,'w0',w0);

% x/y axis
x = (-1000:1000) * 4 * w0 /1000; 
y = (-1000:1000) * 4 * w0 /1000; 

% Test field
LG0 = FT_LG_field(gp,p,l,x,y,[0,0,0]);

% Compute coefficients
[c,n,m] = FT_lg2hg(p,l);

LG_sum = 0;

% LG mode from sum of HG modes
for i=1:length(c)
    LG_sum = LG_sum + c(i) * FT_HG_field(gp,n(i),m(i),x,y,[0,0]); 
end

% Residual 
res = LG0 - LG_sum;

figure
    % Plot test intensity
    subplot(3,2,1)
    imagesc(x*1e2,y*1e2,abs(LG0))
    view(2)
    colorbar()
    xlabel('x [cm]')
    ylabel('y [cm]')
    axis tight;
    axis square;
    grid off;
    drawnow;
    
    % Plot test phase
    subplot(3,2,2)
    imagesc(x*1e2,y*1e2,phase(LG0))
    view(2)
    colorbar()
    xlabel('x [cm]')
    ylabel('y [cm]')
    axis tight;
    axis square;
    grid off;
    drawnow;
    
    % Plot sum intensity
    subplot(3,2,3)
    imagesc(x*1e2,y*1e2,abs(LG_sum))
    colorbar()
    xlabel('x [cm]')
    ylabel('y [cm]')
    axis tight;
    axis square;
    grid off;
    drawnow;
    
    % Plot sum phase
    subplot(3,2,4)
    imagesc(x*1e2,y*1e2,phase(LG_sum))
    colorbar()
    xlabel('x [cm]')
    ylabel('y [cm]')
    axis tight;
    axis square;
    grid off;
    drawnow;
    
    % Plot residual intensity
    subplot(3,2,5)
    imagesc(x*1e2,y*1e2,abs(res))
    colorbar()
    xlabel('x [cm]')
    ylabel('y [cm]')
    axis tight;
    axis square;
    grid off;
    drawnow;
    
    % Plot residual phase
    subplot(3,2,6)
    imagesc(x*1e2,y*1e2,phase(res))
    colorbar()
    xlabel('x [cm]')
    ylabel('y [cm]')
    axis tight;
    axis square;
    grid off;
    drawnow;
    
    
    