%--------------------------------------------------------------------------
% FTE_hg2lg_example.m
%
% A Matlab example script which illustrates the use of the function
% FT_hg2lg.m.  This function outputs the coefficients required to describe 
% a Hermite-Gauss (HG) mode as a sum of Laguerre-Gauss (LG) modes.  Here we
% compare the HG field from the original equation and as a sum of LG modes.
%
% Charlotte Bond    07.01.2013
%--------------------------------------------------------------------------
%

clear all;

% Bema indices/ parameters
w0 = 6.2e-2;
n = 2;
m = 1;
lambda = 1064e-9;
gp = FT_init_gauss_param(lambda,1,'z',0,'w0',w0);

% x/y axis
x = (-1000:1000) * 4 * w0 /1000; 
y = (-1000:1000) * 4 * w0 /1000; 

% Test field
HG0 = FT_HG_field(gp,n,m,x,y,[0,0]);

% Compute coefficients
[c,p,l] = FT_hg2lg(n,m);

HG_sum = 0;

% HG mode from sum of LG modes
for i=1:length(c)
    HG_sum = HG_sum + c(i) * FT_LG_field(gp,p(i),l(i),x,y,[0,0,0]); 
end

% Residual 
res = HG0 - HG_sum;

figure
    % Plot test intensity
    subplot(3,2,1)
    imagesc(x*1e2,y*1e2,abs(HG0))
    view(2)
    colorbar()
    xlabel('x [cm]')
    ylabel('y [cm]')
    axis tight;
    axis square;
    grid off;
    drawnow;
    
    % Plot test phase
    subplot(3,2,2)
    imagesc(x*1e2,y*1e2,phase(HG0))
    view(2)
    colorbar()
    xlabel('x [cm]')
    ylabel('y [cm]')
    axis tight;
    axis square;
    grid off;
    drawnow;
    
    % Plot sum intensity
    subplot(3,2,3)
    imagesc(x*1e2,y*1e2,abs(HG_sum))
    colorbar()
    xlabel('x [cm]')
    ylabel('y [cm]')
    axis tight;
    axis square;
    grid off;
    drawnow;
    
    % Plot sum phase
    subplot(3,2,4)
    imagesc(x*1e2,y*1e2,phase(HG_sum))
    colorbar()
    xlabel('x [cm]')
    ylabel('y [cm]')
    axis tight;
    axis square;
    grid off;
    drawnow;
    
    % Plot residual intensity
    subplot(3,2,5)
    imagesc(x*1e2,y*1e2,abs(res))
    colorbar()
    xlabel('x [cm]')
    ylabel('y [cm]')
    axis tight;
    axis square;
    grid off;
    drawnow;
    
    % Plot residual phase
    subplot(3,2,6)
    imagesc(x*1e2,y*1e2,phase(res))
    colorbar()
    xlabel('x [cm]')
    ylabel('y [cm]')
    axis tight;
    axis square;
    grid off;
    drawnow;
    
    
    