%
%--------------------------------------------------------------------------
% function [gc]=FT_set_mode_coefficent(gc, value, index1, index2)
%
% A function for Matlab to set (overwrite) the value of a mode coefficient 
% in a structure `gc' (see FT_new_mode_coefficients.m).
%
% gc (structure)   :  mode coefficients (see FT_new_mode_coefficients.m)
% index1 (integer) :  first mode index (n for HG, p for LG)
% index2 (integer) :  second mode index (m for HG, l for LG)
% value (complex)  :  mode amplitude coefficient
%
% Andreas Freise 14.11.2009
%--------------------------------------------------------------------------
%

% Description: Sets the value of a mode coefficient in a structure "gc"
% Keywords: set, mode, coefficient, gc

function [gc]=FT_set_mode_coefficent(gc, value, index1, index2)

  baseid='set_mode_coefficient';
  
  idx1=find(gc.index1==index1);
  idx2=find(gc.index2(idx1)==index2);

  if (isempty(idx2))
    msgid=[baseid,':mode_index'];
    result=sprintf('coefficient with index %d, %d does not exist',index1,index2);
    error(msgid,result);
  end
  
  gc.value(idx1(idx2))=value;
  
  