%
%--------------------------------------------------------------------------
% function []=FT_print_gauss_coefficients_to_file(gc, threshold, option, fid, verbose)
%
% A function for Matlab that prints the content of a mode coefficient 
% structure `gc' (see FT_new_mode_coefficients.m).  The function prints the
% coefficients to the screen and saves them in a file.  This function
% is based on FT_print_mode_coefficients, from Andreas Freise's Finesse
% Tools.
%
% gc:            structure, containing mode coefficients (see FT_new_mode_coefficients.m)
% threshold:     float, value for which values should be printed, abs(coeff) must be >= threshold
% option:        'power':       prints coefficients squared
%                'amplitude':   prints amplitude coefficients
% fid:           file identifier for file to write coefficients to
% verbose:       integer, 0 default, 1 prints also mode array index and mode order
%
%
% Charlotte Bond, Andreas Freise    09.03.2011
%--------------------------------------------------------------------------
%

% Description: Prints the content of a mode coefficient structure "gc"
% Keywords: print, content, Gaussian, mode, coefficients, gc

function []=FT_print_gauss_coefficients_to_file(gc, threshold, option, fid, verbose)

  baseid='print_mode_coefficients';
  
  if gc.type==0
    mode_string='u  ';
  elseif gc.type==1
    mode_string='HG ';
  elseif gc.type==2
    mode_string='LG ';
  elseif gc.type==3
    mode_string='LGc';
  end
  
  if strcmp(option, 'power')
      p=2;
	  p_string = 'power';
  else
      p=1;
      p_string = 'amp';
  end
  
  coeff_amps=abs(gc.value);
  
  for n=1:gc.number_of_coeffs
      
    [idx]=find(coeff_amps==max(coeff_amps));
    
    for m=1:length(idx)
      
        j=idx(m);
        
        if abs(gc.value(j))>=threshold
            if verbose==0
                fprintf(' %s%2d,%3d: %s=%2.4g, phase=%2.2g\n',mode_string,gc.index1(j),gc.index2(j),p_string,abs(gc.value(j))^p,phase(gc.value(j)));
                fprintf(fid,' %s%2d,%3d: %s=%2.4g, phase=%2.2g\n',mode_string,gc.index1(j),gc.index2(j),p_string,abs(gc.value(j))^p,phase(gc.value(j)));
            else    
                fprintf(' %3d: %s%2d,%3d (order %2d): %s=%2.4g, phase=%2.2g\n',n,mode_string,gc.index1(j),gc.index2(j),gc.order(j),p_string,abs(gc.value(j))^p,phase(gc.value(j)));
                fprintf(fid,' %3d: %s%2d,%3d (order %2d): %s=%2.4g, phase=%2.2g\n',n,mode_string,gc.index1(j),gc.index2(j),gc.order(j),p_string,abs(gc.value(j))^p,phase(gc.value(j)));
            end
        end
    end
    
    coeff_amps(idx)=0;
    n=n+(length(idx)-1);
    
  end
  
end

  
  
  
    
      
      