%
%--------------------------------------------------------------------------
% function []=FT_print_gauss_coefficients(gc, threshold, verbose)
%
% A function for Matlab that prints the content of a mode coefficient 
% structure `gc', see FT_init_gauss_coefficients.m).
%
% gc:            structure, containing mode coefficients (see FT_new_mode_coefficients.m)
% threshold:     float, value for which values should be printed, abs(coeff) must be >= threshold
% verbose:       integer, 0 default, 1 prints also mode array index and mode order
%
%
% Andreas Freise 14.11.2009
%--------------------------------------------------------------------------
%

% Description: Prints the content of a mode coefficient structure "gc"
% Keywords: print, content, Gaussian, mode, coefficients, gc

function []=FT_print_gauss_coefficients(gc, threshold, verbose)

  baseid='print_mode_coefficients';
  
  if gc.type==0
    mode_string='u  ';
  elseif gc.type==1
    mode_string='HG ';
  elseif gc.type==2
    mode_string='LG ';
  elseif gc.type==3
    mode_string='LGc';
  end
  
  for n=1:gc.number_of_coeffs
    if abs(gc.value(n))>=threshold
      if verbose==0
        fprintf(' %s%2d,%3d: amp=%2.4g, phase=%2.2g\n',mode_string,gc.index1(n),gc.index2(n),abs(gc.value(n)),phase(gc.value(n)));
      else    
        fprintf(' %3d: %s%2d,%3d (order %2d): amp=%2.4g, phase=%2.2g\n',n,mode_string,gc.index1(n),gc.index2(n),gc.order(n),abs(gc.value(n)),phase(gc.value(n)));
      end
    end
  end

  
  
  
    
      
      