%
%------------------------------------------------------------------
% function [gc] = FT_mode_content(gc, gp, field_in, x, y, offset)
%  
% Function for Matlab which computes the deconvolution
% of a given field distribution field_in into Gaussian modes.
% The function can return coefficients for Hermite-Gauss modes,
% helical and sinusoidal Laguerre-Gauss modes. The type of modes
% as well as the maximum mode order is determined by the structre
% `gc' for storing mode coefficients (see FT_new_mode_coefficients.m).
% 
% gp (structure):     structure storing beam parameters, 
%                     see FT_init_gauss_param
% field_in (complex): 2D grid of field amplitudes of the arbitrary input 
%                     field 
% x,y (real):         position vectors defining the grid size [m]
% offset (real):      offset vector for center (x0,y0,phi0) [m,m,deg]
%
% gc (structure):     contains an array of mode indices and amplitides
%                     (see FT_new_mode_coefficients)
% 
% S. Chelkowski, Andreas Freise 13.1.2009 
%-------------------------------------------------------------------
%

% Description: Computes the deconvolution of a given field distribution,
% Description: field_in, into Gaussian modes
% Keywords: deconvolution, field, distribution, Gaussian, mode, content

function [gc] = FT_mode_content(gc, gp, field_in, x, y, offset)

  xpoints=length(x);
  ypoints=length(y);
  
  TEMfield=zeros(ypoints,xpoints);
  
  n_coeff=gc.number_of_coeffs;
  % start loop
  elapsed_time=0;
  for k=1:n_coeff
    tic; % start timer
      if (gc.type<=1)
        TEMfield=FT_HG_field(gp,gc.index1(k),gc.index2(k),x,y,offset); %compute the reference Hermite-Gauss mode
      elseif (gc.type==2)
        TEMfield=FT_LG_field(gp,gc.index1(k),gc.index2(k),x,y,offset); %compute the reference helical Laguerre-Gauss mode
      else
        TEMfield=FT_LG_cos_field(gp,gc.index1(k),gc.index2(k),x,y,offset); %compute the reference sinusoidal Laguerre-Gauss mode
      end      
      gc.value(k)=FT_conv_fields(TEMfield,field_in);          % calculate convolution
      elapsed_time=FT_print_progress(elapsed_time,k,n_coeff,0); % print progress
  end
    
end