%--------------------------------------------------------------------------
% function [coefficients,ps,ls] = FT_hg2lg(n,m)
%
% A function for Matlab which returns the coefficients and mode indices of
% the LG modes required to create a particular HG mode.  See
% FTE_hg2lg_example.m for an example of how to use the function.
%
% n,m:          Indces of the HG mode to re-create.
% coeffcients:  Complex coefficients for each order=n+m LG mode required to
%               re-create HG_n,m.
% ps,ls:        LG mode indices corresponding to coefficients.
%
% Charlotte Bond    07.01.2012
%--------------------------------------------------------------------------
%

function [coefficients,ps,ls] = FT_hg2lg(n,m)

    % Mode order
    N = n+m;
    
    % Create empty vectors for LG coefficients/ indices
    coefficients = linspace(0,0,N);
    ps = coefficients;
    ls = coefficients;
    
    % Calculate coefficients
    for j = 0:N
        
        % Indices for coefficients
        l = 2*j-N;
        p = (N-abs(l))/2;
        
        ps(j+1) = p;
        ls(j+1) = l;
        
        % Coefficient
        c = (1i^m) * sqrt(factorial(N-m)*factorial(m)/(2^N*factorial(abs(l)+p)*factorial(p)));
        c = c * (-2)^m * FT_JacobiPol(abs(l)+p-m,p-m,m,0);
        
        if l<0
            c = conj(c);
        end
        
        coefficients(j+1) = (-1)^p * c;
        
    end


end

