%--------------------------------------------------------------------------
% function [clip] = FT_clipping_loss_LG(w,r,p,l,npix)
%
% Matlab function which computes the clipping loss experienced by a helical
% LG beam on a circular mirror. The accuracy is determined by the number of
% pixels used to simulate the beam.
%
% clip (real)   :    clipping loss experienced, as fraction of incident power        
% w    (real)   :    incident beam size [m]
% r    (real)   :    mirror radius [m]
% p    (int)    :    radial mode index
% w    (int)    :    azimuthal mode index
% npix (int)    :    number of pixels in grid used for calculation. Greater
%                    accuracy is achieved by using more pixels, but
%                    computation time is longer. A value of 400 is a happy
%                    medium.
%
% Paul Fulda 10.12.2009
%--------------------------------------------------------------------------

% Description: Computes the clipping loss experienced by a 
% Description: helical LG beam on a circular mirror
% Keywords: clipping, loss, LG, helical

function clip=FT_clipping_loss_LG(w,r,p,l,npix)
lambda=1064e-9;
x=linspace(-r,r,npix);
field=LGfield(lambda,w,0,p,l,x,x);
for j=1:npix
    for k=1:npix
        if sqrt(x(j)^2+x(k)^2)>r
            field(j,k)=0;
        end
    end
end
clip=1-FT_power_in_field(field,x,x);
% surf((abs(field)).^2,'FaceColor','interp','EdgeColor','none','FaceLighting','phong');
% view(2)