% --------------------------------------------------------------------
% function field = FT_unm (lambda,w0x, w0y, x, y, zx, zy, n, m)
% (requires un.m and HermitePoly.m)
%
% Octave/Matlab function to compute the field of a 2D Hermite-Gauss
% function u_nm(x,y,z), see
% http://relativity.livingreviews.org/Articles/lrr-2010-1/
% 
% lambda = wavelength
% w0x (real): beam widths in x-z plane (tangential)
% w0y (real): beam widths in y-z plane (sagittal)
% x (real):   location on x-axis
% y (real):   location on y-axis
% zx (real):  distance to waist in z-x plane
% zy (real):  distance to waist in z-y plane
% n (int):    order of mode (x-z plane)
% m (int):    order of mode (y-z plane)
%
% field (complex): field amplitude at (x,y,z)
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Andreas Freise 12.12.2006
% --------------------------------------------------------------------

% Description: Computes the field amplitude of a Hermite-Gauss mode
% Keywords: Hermite, mode, Gauss, field, amplitude

function field = FT_unm (lambda,w0x, w0y,x,y,zx,zy,n,m)

q0x=i*w0x*w0x*pi/lambda;
q0y=i*w0y*w0y*pi/lambda;

field=FT_un(lambda,q0x,x,zx,n).*FT_un(lambda,q0y,y,zy,m);