% ------------------------------------------------------
% function field = FT_un (lambda,q0,x,z,n)
% (requires HermitePoly.m)
% 
% Matlab/Octave function to compute the field of a 1D Hermite-Gauss
% function u_n(x,z), see
% http://relativity.livingreviews.org/Articles/lrr-2010-1/
%
% lambda (real): wavelength [m]
% q0 (complex):  Gaussian beam parameter (at beam waist)
% x (real):      location on x-axis
% z (real):      location on z-axis
% n (int):       order of mode
%
% field (complex) field amplitude (at x,z)
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Andreas Freise 15.12.2006
%----------------------------------------------------------------------------------

% Description: Computes the field amplitude of a 1D Hermite-Gauss mode
% Keywords: Hermite, mode, Gauss, field, amplitude

function field = FT_un (lambda,q0,x,z,n)
  k=2*pi/lambda;
  q=q0+z;
  w0=sqrt(lambda/pi*imag(q0));
  w=sqrt(lambda/pi*(q*conj(q))/imag(q));
  field=(2/pi)^(1/4)./sqrt(2^n*factorial(n)*w0).* ...
        sqrt(q0./q).*(q0./conj(q0).*(conj(q)./q)).^(n/2.).*polyval(FT_HermitePoly(n),sqrt(2)*x./w).*exp(-i*k*x.*x/2.0./q);
    
  return
