
%---------------------------------------------------------------------  
% function [zr] = FT_q_to_zr(q)
% 
% Computes the Rayleigh range from the Gaussian beam 
% parameter q:
% 
% zr=imag(q);
%
% q (complex):    Gaussian beam parameter
%
% zr (real):      Rayleigh range [m]
%
% Andreas Freise 26.12.09 afreise@googlemail.com
%---------------------------------------------------------------------  

% Description: Computes the Rayleigh range from the Gaussian beam parameter q
% Keywords: Gaussian, parameter, q, Rayleigh, range, zr

function [zr] = FT_q_to_zr(q);

  zr=imag(q);
   
  return
