
%---------------------------------------------------------------------  
% function [w0,z] = FT_q_to_w0z(q,lambda,nr)
% 
% Computes the waist radius and waist position from the Gaussian beam 
% parameter q:
% 
% w0=sqrt(Im(q)*lambda/nr/pi)
% z=Re(q)  
%
% q (complex):    Gaussian beam parameter
% lambda (real):  wavelength of light [m]
% nr (real):      index of refraction
%
% w0 (real):      waist radius [m]
% z (real):       distance to beam waist [m]
%
% Andreas Freise 29.08.08 afreise@googlemail.com
%---------------------------------------------------------------------  

% Description: Computes the waist radius and waist position from the Gaussian beam
% Description: parameter q
% Keywords: waist, radius, position, Gaussian, parameter, q, w0z

function [w0,z] = FT_q_to_w0z(q,lambda,nr)

  w0=sqrt(imag(q).*lambda./nr/pi);
  z = real(q);

  return
