
%---------------------------------------------------------------------  
% function [w] = FT_q_to_w(q,lambda,nr)
% 
% Computes the beam radius from the Gaussian beam 
% parameter q:
% 
% w=sqrt(lambda./nr/pi.*abs(q).^2./imag(q));
%
% q (complex):    Gaussian beam parameter
% lambda (real):  wave length of light [m]
% nr (real):      index of refraction
%
% w:              beam radius [m]
%
% Andreas Freise 26.12.09 afreise@googlemail.com
%---------------------------------------------------------------------  

% Description: Computes the beam radius from the Gaussian beam parameter q
% Keywords: Gaussian, parameter, q, radius, w

function [w] = FT_q_to_w(q,lambda,nr)

  w=sqrt(lambda./nr/pi.*abs(q).^2./imag(q));
   
  return
