
%---------------------------------------------------------------------  
% function [Rc] = FT_q_to_Rc(q);
% 
% Computes the radius of curvature of a phase front from the Gaussian 
% beam parameter q:
% 
% Rc=abs(q).^2./real(q);
%
% q (complex):    Gaussian beam parameter
%
% Rc (real):      radius of curvature of the beam's phase isosurfaces [m]
%
% Andreas Freise 26.12.09 afreise@googlemail.com
%---------------------------------------------------------------------  

% Description: Computes the radius of curvature of a phase front from the Gaussian 
% Description: beam parameter q
% Keywords: radius, curvature, Gaussian, parameter, q, RC

function [Rc] = FT_q_to_Rc(q);
  
  Rc=abs(q).^2./real(q);

  return
