
%---------------------------------------------------------------------  
% function [Psi] = FT_q_to_Psi(q);
% 
% Computes the Gouy Phase Psi(z) from the Gaussian 
% beam parameter q:
% 
% Psi=atan2(real(q),imag(q));
%
% q (complex):    Gaussian beam parameter
%
% Psi (real):     Gouy phase [rad]
%
% Andreas Freise 26.12.09 afreise@googlemail.com
%---------------------------------------------------------------------  

% Description: Computes the Gouy Phase Psi(z) from the Gaussian beam parameter q
% Keywords: Gaussian, parameter, q, Guoy, phase, psi

function [Psi] = FT_q_to_Psi(q);

  Psi=atan2(real(q),imag(q));
  
  return
