%--------------------------------------------------------------------------
% function [power]=FT_power_in_field(field,x,y)
%
% A function for Matlab that computes the total power in a complex field
% array. 
%
% field:    2D data grid of complex numbers representing the field
% x:        1D data grid of real numbers representing element x positions
% y:        1D data grid of real numbers representing element y positions
% power:    total light power within the field 
%
% Paul Fulda, Andreas Freise    30.11.2009
%--------------------------------------------------------------------------

% Description: Computes the total power in a complex field array
% Keywords: total, power, complex, field

function [power]=FT_power_in_field(field,x,y)

 baseid='power_in_field';

 [yelements,xelements]=size(field);

 if size(x)~=xelements
   result='Number of elements in position vector x does not correspond to the number of columns in the field array.';
   msgid=[baseid,':checkarguments']
   error(msgid,result);
 end
 if size(y)~=yelements
   result='Number of elements in position vector y does not correspond to the number of rows in the field array.';
   msgid=[baseid,':checkarguments']
   error(msgid,result);
 end

 
 % computing the numerical integration using Matlabs tprapezoidal method:
 p1=trapz(x,abs(field).^2,2);
 power=trapz(y,p1);

 
 
 
 
 