%--------------------------------------------------------------------------
% function [gc, gc.number_of_coeffs]=FT_new_mode_coefficents(type, lambda, w0x, w0y, z0x, z0y, max_order)
%
% A function for Matlab that returns an empty array for storing
% mode coefficients.
%
% type (string):   string, must be either `none', `HG', `LG' or `LGcos'. 'none' will
%                  simply create an empty arry. HG,LG and LGcos will already fill
%                  the index numebrs in the struct for Hermite-Gauss, helical Laguerre-Gauss 
%                  and sinusoidal LG modes respectively.         
% lambda (real):   wavelength [m]
% w0x/w0y (real):  beam radius (x-z,y-z plane) [m]
% z0x/z0y (real):  position on z-axis (distance from beam waist at z=0) [m]                    
%                  negative values: running towards the waist
%                  positive values: running away from the waist
% max_order (integer) : maximum order for the modes (must be >=0)
%
% gc:            structure for storing mode coefficients:
%                type: 0 for none, 1 for HG, 2 for LG, 3 for LGcos
%                maxorder: maximum mode order
%                number_of_coeffs: integer, number of coefficients  
%                                        (i.e. empty entries in the gc structure)
%                index1: vector of first mode index (n or p)
%                index2: vector of second mode index (m or l)
%                order:  vector of the orders of respective coefficents
%                value:  vector of complex value of the coefficient (here set to zero)
%
% number_of_coeffs: integer, number of empty entries in the gc structure
%
% Andreas Freise 14.11.2009
%--------------------------------------------------------------------------
%

% Description: Returns an empty array for storing mode coefficients
% Keywords: empty, mode, coefficient, new

function [gc, number_of_coeffs]=FT_new_mode_coefficients(type,lambda, w0x, w0y, z0x, z0y, max_order)

  fprintf('Warning, this function is depreciated, please use FT_init_gauss_coefficients!\n');

  baseid='new_mode_coefficients';
  
  if (strcmp(type,'none'))
    gc.type=0;
  elseif (strcmp(type,'HG'))
    gc.type=1;
  elseif (strcmp(type,'LG'))
    gc.type=2;
  elseif (strcmp(type,'LGcos'))
    gc.type=3;
  else
    msgid=[baseid,':mode_type'];
    result='mode type must be "none", "HG", "LG" or "LGcos"';
    error(msgid,result);
  end
  
  if (max_order<0)
    msgid=[baseid,':mode_order'];
    result='maximum order must be >=0';
    error(msgid,result);
  end

  gc.max_order=max_order;
  gc.lambda=lambda;
  gc.w0x=w0x;
  gc.w0y=w0y;
  gc.z0x=z0x;
  gc.z0y=z0y;

  if gc.type==0
    number_of_coeffs=max_order;
  elseif gc.type==1
    number_of_coeffs=(max_order+1)*(max_order+2)/2;
  else
    number_of_coeffs=(max_order+1)*(max_order+2)/2;
  end

  gc.number_of_coeffs=number_of_coeffs;
  
  gc.index1=zeros(gc.number_of_coeffs,1);
  gc.index2=zeros(gc.number_of_coeffs,1);
  gc.order=zeros(gc.number_of_coeffs,1);
  gc.value=zeros(gc.number_of_coeffs,1);
  
  
  % fill index arrays
  idx=1;
  if gc.type==1
    for k=0:max_order
      for l=0:k
        gc.order(idx)=k;
        gc.index1(idx)=l;
        gc.index2(idx)=k-l;
        idx=idx+1;
      end
    end
  elseif gc.type>1
    for k=0:max_order
      for l=0:floor(k/2)
        gc.order(idx)=k;
        gc.index1(idx)=l;
        gc.index2(idx)=k-2*l;
        idx=idx+1;
        if ((k-2*l)~=0)
          gc.order(idx)=k;
          gc.index1(idx)=l;
          gc.index2(idx)=-(k-2*l);
          idx=idx+1;
        end
      end
    end
  end
    
      
      