%
%------------------------------------------------------------------------
% function [field] = FT_mode_coefficients_to_field(gc, gp x, y)
%  
% Function for Matlab that computes a complex field array from 
% a set of Gaussian mode coefficients.
% 
% gc (structure):   contains an array of mode indices and amplitides
%                   (see FT_init_gauss_coefficients)
% gp (structure):   contains the Gaussian parameter
%                   (see FT_init_gauss_parameters)
% x,y (real):       position vectors defining the grid size [m]  
% offset (real):    vector of offsets [x0,y0,phi0] with phi0 giving the
%                   rotation around the center x0,y0
% verbose (boolean): verbose=true prints progress percentage
%
% field (complex):  2D grid of field amplitudes of the arbitrary input 
%                   field 
% 
% Part of the SimTools Package
% Andreas Freise 07.03.2010 
%------------------------------------------------------------------------
%

% Description: Computes a complex field array from a set of Gaussian mode coefficients
% Keywords: mode, coefficient, field, Gaussian

function [field] = FT_mode_coefficients_to_field(gc, gp, x,y,offset, verbose)

  xpoints=length(x);
  ypoints=length(y);
  
  field=zeros(ypoints,xpoints);

  n_coeff=gc.number_of_coeffs;

  elapsed_time=0;
  for k=1:n_coeff
    if (gc.value(k)~=0)
      % start timer
      tic; 
        if (gc.type<=1)
          field=field+gc.value(k)*FT_HG_field(gp,gc.index1(k),gc.index2(k),x,y,offset);
        elseif (gc.type==2)
          field=field+gc.value(k)*FT_LG_field(gp,gc.index1(k),gc.index2(k),x,y,offset);
        else
          field=field+gc.value(k)*FT_LG_cos_field(gp,gc.index1(k),gc.index2(k),x,y,offset);
        end      
        % print progress
        if(verbose)
          elapsed_time=FT_print_progress(elapsed_time,k,n_coeff,0); 
        end
    end
  end
end