%
%------------------------------------------------------------------------
% function [field] = FT_gauss_coefficients_to_field(gp, gc, x, y, offset)
%  
% Function for Matlab that computes a complex field array from 
% a set of Gaussian mode coefficients.
% 
% gp (structure):   contains info about the mode such as Gaussian beam parameter
%                   and wavelength
%                   (see FT_init_gauss_params.m)
% gc (structure):   contains an array of mode indices and amplitides
%                   (see FT_init_gauss_coefficients)
% x,y (real):       position vectors defining the grid size [m]  
% offset (real):      offset vector for center (x0,y0,phi0) [m,m,deg]
%
% field (complex):  2D grid of field amplitudes of the arbitrary input 
%                   field 
% 
% S. Chelkowski, Andreas Freise 26.12.2009 
%------------------------------------------------------------------------
%

% Description: Computes a complex field array from 
% Description: a set of Gaussian mode coefficients
% Keywords: Gaussian, mode, coefficient, field

function [field] = FT_gauss_coefficients_to_field(gp, gc, x, y, offset)

  xpoints=length(x);
  ypoints=length(y);
  
  field=zeros(ypoints,xpoints);

  n_coeff=gc.number_of_coeffs;

  elapsed_time=0;
  for k=1:n_coeff
    tic; % start timer
      if (gc.type<=1)
        field=field+gc.value(k)*FT_HG_field(gp,gc.index1(k),gc.index2(k),x,y,offset); %compute the reference Laguerre-Gauss mode
      elseif (gc.type==2)
        field=field+gc.value(k)*FT_LG_field(gp,gc.index1(k),gc.index2(k),x,y,offset); %compute the reference Laguerre-Gauss mode
      else
        field=field+gc.value(k)*FT_LG_cos_field(gp,gc.index1(k),gc.index2(k),x,y,offset); %compute the reference Laguerre-Gauss mode
      end      
      elapsed_time=FT_print_progress(elapsed_time,k,n_coeff,0); % print progress
  end
    
end