%
%--------------------------------------------------------------------------
% function [c]=FT_conv_fields(field1, field2)
%
% A function for Matlab that computes the scalar product between two
% complex 2D data arrays (similar to a convolution)
%
% field1:   2D data grid of complex numbers
% field2:   2D data grid of complex numbers
%
% c: value computed as c=int(field1*field2)/(|field1|^2*|field2|^2)
%
%
% Andreas Freise  14.08.2009
%--------------------------------------------------------------------------
%

% Description: Computes the scalar product between two complex 2D data arrays
% Keywords: scalar, dot, product, 2D, conv, fields

function [c]=FT_conv_fields(field1, field2)
  
  c=sum(sum(field1.*conj(field2)));
  cn=sum(sum((field1.*conj(field1))));
  cn=cn*sum(sum((field2.*conj(field2))));
  c=conj(c/sqrt(cn));