%
%--------------------------------------------------------------
% function [field]=FT_SG_field(w,n,x,y,offset)
% (requires FT_SGB.m)
%
% Matlab/Octave function to fill a 2D grip with the field
% amplitudes for a super-Gaussian beam at its waist
%
% w (real):         beam radius
% n (integer):      order of super-Gaussian
% x,y (real):       position vectors defining the grid size [m]
% offset (real):    [x_offset,y_offset,phi_offset] offset vector for position
%                   and rotation [m,m,deg]
%
% field (complex):  2D grid of field amplitudes
%
% Part of the SimTools package
% Andreas Freise 16.05.2010
%--------------------------------------------------------------
%

% Description: Fills a 2D grip with the field amplitudes
% Description: for a super-Gaussian beam at its waist
% Keywords: 2D fill, field, amplitude, super, Gaussian, waist

function [field]=FT_SG_field(w,n,x,y,offset)
  
  baseid='SG_field';

  xpoints=length(x);
  ypoints=length(y);
  
  field=zeros(ypoints,xpoints);
  
  [X,Y] = meshgrid(x-offset(1),y-offset(2));
  r = sqrt(X.^2+ Y.^2);
 
  for i=1:ypoints
    field(i,:)=FT_SGB(r(i,:),w,n);
  end