
%---------------------------------------------------------------------  
% function [w0,z] = FT_Rcw_to_w0z(Rc,w,lambda,nr)
% 
% Computes the waist radius and waist position from beam size
% w(z) and radius of curvature Rc(z):
% 
% Rc (real): radisu of curvature [m]
% w (real): beam radius [m]
% nr: index of refraction
%
% w0: waist radius [m]
% z: distance to beam waist [m]
%
% Andreas Freise 29.08.08 afreise@googlemail.com
%---------------------------------------------------------------------  

% Description: Computes the waist radius and waist position from beam size w(z)
% Description: and radius of curvature Rc(z)
% Keywords: waist, radius, w0z, position, radius, curvature, Rcw

function [w0,z] = FT_Rcw_to_w0z(Rc,w,lambda,nr)
  
  %%% TODO add a citation to Paul's documents sometimes
    
  tmp=(pi*w.^2/lambda/nr).^2;
  w0=((Rc.^2 .* w.^4)./(Rc.^2 + tmp).* (1 - tmp./(Rc.^2 + tmp))).^(1/4);
  z=tmp.*Rc./(Rc.^2+tmp);

  return