%
%--------------------------------------------------------------
% function [field]=FT_LG_field(gp,p,l,x,y,offset)
%
% Matlab/Octave function to fill a 2D grid with complex field
% amplitudes for a Laguerre-Gauss beam.
%
% gp (structure):   structure storing beam parameters, 
%                   see FT_init_gauss_param
% p,l (int):        mode indices of LG TEM_p,l mode
%                   (p is the radial index)
% x,y (real):       position vectors defining the grid size [m]
% offset (real):    [x_offset,y_offset,phi_offset] offset vector for position
%                   and rotation [m,m,deg]
%
% field (complex):  2D grid of field amplitudes
%
% Andreas Freise 25.03.2007
%--------------------------------------------------------------
%

% Description: Fills a 2D grid with complex field amplitudes 
% Description: for a Laguerre-Gauss beam
% Keywords: LG, field, fill, 2D, amplitude, Laguerre-Gauss

function [field]=FT_LG_field(gp,p,l,x,y,offset)
  
  baseid='LG_field';

  if (gp.is_astigmatic)
    msgid=[baseid,':checkinarg'];
    result='LG beams cannot be created from astigmatic Gaussian beam parameters.';
    error(msgid,result);
  end
  
  xpoints=length(x);
  ypoints=length(y);
  
  field=zeros(ypoints,xpoints);
  
  [X,Y] = meshgrid(x-offset(1),y-offset(2));
  r = sqrt(X.^2+ Y.^2);
  sr = sqrt(2)*r/gp.w(1);
  phi = atan2(Y,X)+offset(3)/180.0*pi;
 
  for i=1:ypoints
    field(i,:)=FT_ulp(gp.lambda,gp.w0(1),r(i,:),phi(i,:),gp.z(1),p,l);
  end