%
%--------------------------------------------------------------
% function field=FT_HG_field(gp ,n ,m ,x ,y, offset)
%
% Matlab/Octave function to fill a 2D grid with complex field
% amplitudes for a Hermite-Gauss beam (uses FT_unm.m).
%
% gp (structure):   structure storing beam parameters, 
%                   see FT_init_gauss_param
% n,m (int):        mode indices of TEM_n,m mode
% x,y (real):       position vectors defining the grid size [m]
% offset (real):    [x_offset,y_offset,phi_offset] offset vector for position
%                   and rotation [m,m,deg]
% field (complex):  2D grid of field amplitudes
%
% Part of the Simtools package, http://www.gwoptics.org/simtools
% Andreas Freise 15.12.2006
%--------------------------------------------------------------
%

% Description: Fills a 2D grid with complex field amplitudes for a Hermite-Gauss beam
% Keywords: fill, 2D, HG, field, amplitude, Hermite-Gauss

function field=FT_HG_field(gp,n,m,x,y, offset)

  xpoints=length(x);
  ypoints=length(y);
  
  field=zeros(ypoints,xpoints);
  
  %{
  %%% TODO: need to test rotation below
  phi=offset(3)/180.*pi;
  M_rot=[cos(phi), -sin(phi); sin(phi), cos(phi)];
  Cnew=M_rot*[x;y];
  x=Cnew(1,:);
  y=Cnew(2,:);
  %}
 
  x=x-offset(1);
  y=y-offset(2);
 
  
  for i=1:ypoints
    field(i,:)=FT_unm(gp.lambda,gp.w0(1), gp.w0(2), x, y(i), gp.z(1), gp.z(2), n, m);
  end
  
  return