%
%--------------------------------------------------------------
% function [field]=FT_CON_field(w0,x,y,z,offset)
% (requires FT_SGB.m)
%
% Matlab/Octave function to fill a 2D grip with the field
% amplitudes for a conical beam at the waist as defined in 
% Bondarescu, M.; Kogan, O. & Chen, Y. Optimal light beams and mirror 
% shapes for future LIGO interferometers Phys. Rev. D, 2008, 78, 082002-+
%
% lambda (real):    laser wavelength [m]
% w0 (real):        beam waist radius [m]
% x,y (real):       position vectors defining the grid size [m]
% z (real):         distance to beam waist [m]
% offset (real):    [x_offset,y_offset,phi_offset] offset vector for position
%                   and rotation [m,m,deg]
%
% field (complex):  2D grid of field amplitudes
%
% Part of the SimTools package
% Andreas Freise 10.06.2010
%--------------------------------------------------------------
%

% Description: Fills a 2D grip with the field amplitudes for 
% Description: a conical beam at the waist
% Keywords: 2D, fill, conical, amplitude, waist

function [field]=FT_CON_field(lambda,w0,x,y,z,offset)
  
  baseid='CON_field';

  xpoints=length(x);
  ypoints=length(y);
  
  field=zeros(ypoints,xpoints);
  
  [X,Y] = meshgrid(x-offset(1),y-offset(2));
  r = sqrt(X.^2+ Y.^2);
 
  for i=1:ypoints
    field(i,:)=FT_conical(lambda,r(i,:),w0,z);
  end