%
%------------------------------------------------------------------
% FTE_FFT_results_premodecleaner
%  
% Matlab script that re-plots the results from the example
% script FTE_FFT_premodecleaner.
%
% Part of the SimTools package
% Andreas Freise 05.01.2010 afreise@googlemail.com 
%-------------------------------------------------------------------
%

% run after FTE_FFT_premodecleaner, or after loading 
% the mat file with the results

figure
semilogy(result.scan/Laser.lambda,result.power);
title('Cavity Scan')
xlabel('tuning [1/lambda]')
ylabel('circulating power')
drawnow;

figure
plot(result.zoom1/Laser.lambda,result.power_zoom1);
title('Cavity Zoom')
xlabel('tuning [1/lambda]')
ylabel('circulating power')
drawnow;

figure
plot(result.zoom2/Laser.lambda,result.power_zoom2);
title('Cavity Zoom')
xlabel('tuning [1/lambda]')
ylabel('circulating power')
drawnow;

figure
plot(result.power_buildup);
title('Power Buildup')
xlabel('iteration')
ylabel('circulating power')
drawnow;


fprintf('\n === Results \n')
fprintf(' Operating point [1/lambda]: %f \n',result.operating_point/Laser.lambda); 
fprintf(' Operating point [m]:        %g \n',result.operating_point); 
fprintf(' \n');
fprintf(' Circulating power [W]: %f \n', FT_power_in_field(result.f_circ,Grid.xaxis,Grid.yaxis));
fprintf(' Reflected power   [W]: %f \n', FT_power_in_field(result.f_refl,Grid.xaxis,Grid.yaxis));
fprintf(' Transmitted power [W]: %f \n', FT_power_in_field(result.f_trans,Grid.xaxis,Grid.yaxis));

% Do mode decomposition
[gp] = FT_init_gauss_param(Laser.lambda,1,'q',q);
max_mode_order = 9;
[gc,n_coeff]=FT_init_gauss_coefficients('HG', max_mode_order);
fprintf(' Computing mode coefficients for transmitted field...\n');
[gc] = FT_mode_content(gc, gp, result.f_trans,Grid.xaxis,Grid.yaxis);
FT_print_gauss_coefficients(gc,1e-3,0);
fprintf(' Total power in modes %.3g (should be 1)!\n',sum(abs(gc.value(:)).^2));

figure  
subplot(2,2,1)
FT_FFT_plot_field(field,2)
title('Input field')
subplot(2,2,2)
FT_FFT_plot_field(result.f_circ,2)
title('Circulating field')
subplot(2,2,3)
FT_FFT_plot_field(result.f_refl,2)
title('Reflected field')
subplot(2,2,4)
FT_FFT_plot_field(result.f_trans,2)
title('Transmitted field')
drawnow;  



