%
%---------------------------------------------------------------------  
% function [map] = FT_tilt_map(map, mygrid, alpha)
% 
% Matlab function that computes a tilted mirror map 
% (rotate by alpha around the y-axis).
%
% map (real):          2D data array containing a mirror map
%                      NOTE: do not use complex numbers here unless
%                      you know what you are doing!
% mygrid (structure):  stores parameters of a 2D grid for FFT computations,
%                      see FT_init_grid.m
% alpha (real):        Angle for tilting the mirror the mirror [deg]
%
% Part of the SimTools package
% Andreas Freise, Jerome Degallaix 26.12.2009 afreise@googlemail.com
%---------------------------------------------------------------------  
%

% Description: Computes a tilted mirror map
% Keywords: tilt, tilted, mirror, map

function [map] = FT_tilt_map(map, mygrid, alpha)
  
  alpha_X = mygrid.X*cos(alpha/180.0*pi);
  map=interp2(alpha_X,mygrid.Y,map,mygrid.X,mygrid.Y,'cubic',0);

  return
 
