% Keywords: 2D, hanning, window

function [window] = FT_hanning_window2D(N,offset)
  
pN = ceil(N/2);

window.data=zeros(N,N);

n=linspace(-pN,N-pN,N);

[X,Y]=meshgrid(n,n);

R=sqrt(X.^2+Y.^2);
[idx]=find(R>pN-offset);

window.data=0.5*(1-cos(2*pi*(pN-offset-R)/N));
window.data(idx)=0.0;

window.s1=sum(sum(window.data));
window.s2=sum(sum(window.data.^2));
window.R=R;